﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.Models;
using PpmsDataWebService.ModelsEnumTypes;
using VA.PPMS.Context;

namespace PpmsDataWebService.Mappers
{
    public class VaProviderRelationshipMap
    {
        public static async Task<IQueryable<VaProviderRelationship>> MapVaProviderRelationships(List<ppms_vaproviderrelationship> ppmsVaProviderRelationships, string mapRelatedType, PpmsContext context)
        {
            var vaProviderRelationships = new List<VaProviderRelationship> { };
            foreach (var ppmsVaProviderRelationship in ppmsVaProviderRelationships)
            {
                var vaProviderRelationship = new VaProviderRelationship
                {
                    Name = ppmsVaProviderRelationship.ppms_name,
                };

                if (ppmsVaProviderRelationship.ppms_participationstartdate != null)
                {
                    vaProviderRelationship.StartDate = ppmsVaProviderRelationship.ppms_participationstartdate.Value;
                }

                if (ppmsVaProviderRelationship.ppms_participationenddate != null)
                {
                    vaProviderRelationship.EndDate = ppmsVaProviderRelationship.ppms_participationenddate.Value;
                }
          
                if (ppmsVaProviderRelationship.ppms_Credentialing != null)
                {
                    vaProviderRelationship.CredentialName = ppmsVaProviderRelationship.ppms_Credentialing.Name;
                }


                //Relation Type Switch
                if (ppmsVaProviderRelationship.ppms_relationship != null)
                    switch (ppmsVaProviderRelationship.ppms_relationship.Value)
                    {
                        case (int)ppms_vaproviderrelationship_ppms_relationship.AcademicAffiliate_AA:
                            vaProviderRelationship.RelationshipType = RelationshipType.AcademicAffiliate;
                            break;
                        case (int)ppms_vaproviderrelationship_ppms_relationship.Choice:
                            vaProviderRelationship.RelationshipType = RelationshipType.Choice;
                            break;
                        case (int)ppms_vaproviderrelationship_ppms_relationship.DoD:
                            vaProviderRelationship.RelationshipType = RelationshipType.DoD;
                            break;
                        case (int)ppms_vaproviderrelationship_ppms_relationship.FederallyQualifiedHealthCenter_FQHC:
                            vaProviderRelationship.RelationshipType = RelationshipType.FederallyQualifiedHealthCenter;
                            break;
                        case (int)ppms_vaproviderrelationship_ppms_relationship.IHS:
                            vaProviderRelationship.RelationshipType = RelationshipType.IHS;
                            break;
                        case (int)ppms_vaproviderrelationship_ppms_relationship.Network:
                            vaProviderRelationship.RelationshipType = RelationshipType.Network;
                            break;
                        case (int)ppms_vaproviderrelationship_ppms_relationship.NonLicensedPractitioner_NLPProviderAgreement:
                            vaProviderRelationship.RelationshipType = RelationshipType.NonLicensensedPractitioner;
                            break;
                        case (int)ppms_vaproviderrelationship_ppms_relationship.PC3:
                            vaProviderRelationship.RelationshipType = RelationshipType.PC3;
                            break;
                        case (int)ppms_vaproviderrelationship_ppms_relationship.TribalHealthPlan_THP:
                            vaProviderRelationship.RelationshipType = RelationshipType.TribalHealthPlan;
                            break;
                        case (int)ppms_vaproviderrelationship_ppms_relationship.VA:
                            vaProviderRelationship.RelationshipType = RelationshipType.VA;
                            break;
                    }

                //Extract the Related type from queryType string
                if (mapRelatedType.Contains("?$expand=Credentialing"))
                    mapRelatedType = "Credentialing";
                if (mapRelatedType.Contains("?$expand=AgreementProviders"))
                    mapRelatedType = "AgreementProviders";
                if (mapRelatedType.Contains("?$expand=ProviderServices"))
                    mapRelatedType = "ProviderServices";
                if (mapRelatedType.Contains("?$expand=ProviderNetworks"))
                    mapRelatedType = "ProviderNetworks";

                //Map Related Types
                switch (mapRelatedType)
                {
                    case "Credentialing":
                        //Lookup and Map the related Credential
                        var ppmsCredential =
                            context.ppms_providercredentialSet.FirstOrDefault(i => i.Id == ppmsVaProviderRelationship.ppms_Credentialing.Id);
                        var ppmsCredsList = new List<ppms_providercredential> { ppmsCredential };
                        vaProviderRelationship.Credentialing =
                            await ProviderCredentialsMap.MapProviderCredentials(ppmsCredsList, "None", context);
                        break;
                    case "AgreementProviders":
                        //Lookup and Map the related Credential
                        var ppmsAgreementProviders =
                            context.ppms_agreementproviderSet.Where(i => i.ppms_VAProviderRelationshipId.Id == ppmsVaProviderRelationship.Id);
                        var ppmsAgreementProvidersList = ppmsAgreementProviders.ToList();
                        vaProviderRelationship.AgreementProviders =
                            await AgreementProvidersMap.MapAgreementProviders(ppmsAgreementProvidersList, "None", context);
                        break;
                    case "ProviderServices":
                        //Lookup and Map the related Credential
                        var ppmsProviderServices =
                            context.ppms_providerserviceSet.Where(i => i.ppms_VAProviderRelationshipId.Id == ppmsVaProviderRelationship.Id);
                        var ppmsProviderServicesList = ppmsProviderServices.ToList();
                        vaProviderRelationship.ProviderServices =
                            await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                        break;
                    case "ProviderNetworks":
                        //Lookup and Map the related Credential
                        var ppmsProviderNetworks =
                            context.ppms_vaprovidernetworkSet.Where(i => i.ppms_VAProviderRelationshipId.Id == ppmsVaProviderRelationship.Id);
                        var ppmsProviderNetworksList = ppmsProviderNetworks.ToList();
                        vaProviderRelationship.ProviderNetworks =
                            await ProviderNetworkMap.MapProviderNetworks(ppmsProviderNetworksList, "None", context);
                        break;
                    default:
                        break;
                }

                vaProviderRelationships.Add(vaProviderRelationship);
            }
            return vaProviderRelationships.AsQueryable();
        }
    }
}